package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="OnlineData",schema="hib")
public class OnlineData extends BusinessObject {

	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="templateid")
	OnlineDataTemplate onlineDataTemplate;
	
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="requestid")
	Request request;

	OnlineData(){}
	
	public static OnlineData create(final String createdBy) throws ValidationException {
	
		ValidationHelper.required("Created By", createdBy);
		
		return null;
	}
	
	public Request getRequest() {
		return request;
	}

	public DartRequest getDartRequest() {
		return (DartRequest)request;
	}
}
